:
# RCSid:
#	$Id: sb-funcs.sh,v 1.79 2025/12/24 03:28:33 sjg Exp $
#
#	@(#) Copyright (c) 2009-2024 Simon J. Gerraty
#
#	SPDX-License-Identifier: BSD-2-Clause
#      
#	Please send copies of changes and bug-fixes to:
#	sjg@crufty.net
#

_SB_FUNCS_SH=:

Myname=${Myname:-`basename $0 .sh`}
Mydir=${Mydir:-`dirname $0`}
pwd=${pwd:-'pwd'}
case "$Mydir" in
.) Mydir=`$pwd`;;
esac
SB_TOOLS=${SB_TOOLS:-$Mydir}
# order of some of these matters
$_HAVE_SH . $SB_TOOLS/have.sh
$_isPOSIX_SHELL_SH . $SB_TOOLS/isposix-shell.sh
$_DEBUG_SH . $SB_TOOLS/debug.sh
$_OS_SH . $SB_TOOLS/os.sh
$_HOOKS_SH . $SB_TOOLS/hooks.sh
$_ADD_PATH_SH . $SB_TOOLS/add_path.sh
$_TEST_OPTS_SH . $SB_TOOLS/test_opt.sh
$_FIND_IT_SH . $SB_TOOLS/find_it.sh
$_MKOPT_SH . $SB_TOOLS/mkopt.sh

DebugOn ${MYNAME:-$Myname}

ev=.sandbox-env
rc=.sandboxrc

##
# varName name
#
# turn "name" something into a useful var name
varName() {
    case "$1" in
    *[!A-Za-z0-9_]*) vn=`echo $1 | sed 's,[^A-Za-z0-9_],_,g'`;;
    *) vn=$1;;
    esac
    echo $vn
}

##
# evalVar val
#
# if "val" contains '$' eval it
#
evalVar() {
    val="$@"
    while :
    do
        case "$val" in
	*\$*) eval "val=\"$val\"";;
	*) break;;
	esac
    done
    echo "$val"
}

DebugOn SB_VARMYNAME_LIST
# we sometimes need these as var names
# MYNAME is our canonical name
# Myname is from $0
for n in Myname MYNAME
do
    eval vn=\$$n
    vn=`varName $vn`
    eval var${n}=$vn
done
# compute this once
if test x$varMyname = x$varMYNAME; then
    SB_VARMYNAME_LIST=$varMyname
else
    SB_VARMYNAME_LIST="$varMyname $varMYNAME"
fi
DebugOff SB_VARMYNAME_LIST

##
# find_sb start
#
# Find .sandbox-env in "start" (.) or above.
#      
find_sb() {
    find_it --start ${1:-.} --dir $ev
}

# for compatability with atexit.sh
Exit() {
    ExitStatus=$1
    exit $1
}

warning() {
    echo "WARNING: $@" >&2
}

error_more() {
    echo "ERROR: $@" >&2
}

error() {
    error_more "$@"
    Exit 1
}

# we are providing source_rc
_SOURCE_SH=:

##
# source_rc [options] file ...
#
# requires 'local' for source_file etc to have correct values when
# used recursively.
# --all  include all we find (default)
# --once avoids repeats
# --one  stops after first one we find
sb_include_dirs="${sb_include_dirs:-$Mydir}"
source_rc() {
    eval $_local f rc source_dir source_file _0 _1

    _0=: _1=: rc=1
    while :
    do
        case "$1" in
        --all) _1=:; shift;;
        --once) _0=; shift;;
        --one) _1=return; shift;;
        *) break;;
        esac
    done
    for f in "$@"
    do
        [ -s $f ] || continue
        case $f in
        */*) source_dir=`dirname $f` source_file=`basename $f`;;
        *) source_dir=. source_file=$f;;
        esac
        source_dir=`'cd' "$source_dir" && 'pwd'`
        : is $_0$source_dir/$source_file in ,$sb_included,
        case ",$sb_included," in
        *,$_0$source_dir/$source_file,*) continue;;
        esac
        sb_included=$sb_included,$source_dir/$source_file
        # be compatible with dot()
        dotted="$dotted $source_dir/$source_file"
        case " $sb_include_dirs " in
        *" $source_dir "*) ;;
        *) sb_include_dirs="$sb_include_dirs $source_dir";;
        esac
        . $f
        $_1 $?
        rc=0			# we included something
    done
    return $rc
}

##
# dot_find file ...
#
# for each file if it does not exist relative to cwd
# try each directory we have sourced things from.
#
dot_find() {
    eval $_local d f rc

    rc=1
    for f in "$@"
    do
        for d in "" $sb_include_dirs
        do
            source_rc ${d:+$d/}$f || continue
            rc=0
            break
        done
    done
    return $rc
}

# for compatability with others
dot() { source_rc "$@"; }
dot_once() { source_rc --once "$@"; }
source_one_rc() { source_rc --one "$@"; }
source_once() { source_rc --once "$@"; }

##
# sb_run_hooks name [args]
# we run sb_${name}_hooks ${varMyname}_${name}_hooks and
# ${varMYNAME}_${name}_hooks passing args provided.
#
sb_run_hooks() {
    _n=$1; shift

    DebugOn sb_run_hooks:$_n run_hooks:$_n
    case "$_n" in
    run) _p1=;;
    *) _p1=sb;;
    esac
    for _p in $_p1 $SB_VARMYNAME_LIST
    do
        run_hooks ${_p}_${_n}_hooks "$@"
    done
    DebugOff rc=$? sb_run_hooks:$_n run_hooks:$_n
}

##
# sb_project_init
#
# we call this after we know $SB_PROJECT.
# Under $SB_TOOLS and any directories in $SB_RC_DIR_LIST,
# we look in sb-project.d/ and ${MYNAME}-project.d/
# for $SB_PROJECT.rc or its lower case version if needed.
# We also trim $SB_PROJECT at any '-*' and look for that
# (and its lower case version) too.
#
# If we are 'mksb' SB_PROJECT may not yet have its canonical value
# so we also look for all the above as prefixes eg $SB_PROJECT*.rc
# etc.
#
# Finally we run project_init and project hooks
#
sb_project_init() {
    DebugOn sb_project_init
    eval $_local prefixes p
    prefixes=$SB_PROJECT

    case "$SB_PROJECT" in
    *-*)
        eval $_local bp
        if $isPOSIX_SHELL; then
            bp=${SB_PROJECT%%-*}
        else
            bp="`IFS=-; set -- $SB_PROJECT; echo $1`"
        fi
        add_list_once prefixes $bp
        ;;
    esac
    case "$SB_PROJECT" in
    *[A-Z]*) p=`echo $prefixes | toLower`
        add_list_once prefixes $p
        ;;
    esac
    : is MYNAME=$MYNAME = mksb
    case "$MYNAME" in
    mksb) # SB_PROJECT may not yet be canonical
        # remember the original
        _SB_PROJECT=$SB_PROJECT
        for p in $prefixes
        do
            add_list_once prefixes "$p*"
        done
        ;;
    esac
    for top in $SB_TOOLS $SB_RC_DIR_LIST
    do
        for p in $prefixes
        do
            source_rc --once $top/sb-project.d/${p}.rc
            source_rc --once $top/${MYNAME}-project.d/${p}.rc
        done
    done
    sb_run_hooks project_init
    sb_run_hooks project
    DebugOff project_init
}

##
# sb_hooks sb
#
# cd "sb"
# source any of the following if they exist
# ../.sandboxrc
# ./.sandboxrc
# 
# run init hooks
# source ./.sandbox-env
# run setup hooks
# 
sb_hooks() {
    DebugOn sb_hooks
    'cd' "$1" || Exit 1
    SB=`$pwd`
    SB_NAME=`basename $SB`
    export SB SB_NAME

    _mk_opt yes SB_BASE_RC
    if [ $MK_SB_BASE_RC = yes ]; then
        eval $_local _base
        case "$MYNAME" in
        mksb) _base=$SB_BASE;;
        *) _base=`unset SB_BASE; . ./$ev; echo $SB_BASE`;;
        esac
        source_rc --once ${_base:-..}/$rc ../$rc
    fi
    source_rc --once ./$rc
    sb_run_hooks init
    case "$MYNAME" in
    mksb) ;;
    *) source_rc ./$ev;;
    esac
    # no guarantee we have SB_PROJECT!
    test -z "$SB_PROJECT" || sb_project_init
    sb_run_hooks setup
    DebugOff sb_hooks
}

add_list() {
    _list=$1; shift
    eval "$_list=\"\$$_list $@\""
}

sort_list() {
    case "$1" in
    --) _u=; shift;;
    -[run]*) _u=$1; shift;;
    *) _u=;;
    esac
    case "$1" in
    "") return;;
    esac
    for i in "$@"
    do
        echo $i
    done | sort $_u
}

$_HELP_FUNCS_SH . $SB_TOOLS/help-funcs.sh
add_hooks docs_hooks help_docs_hook
add_docs $SB_TOOLS/sb-funcs.sh $SB_TOOLS/help-funcs.sh

case "/$0" in
*sb-funcs*) op=$1; shift; $op "$@";;
esac
